unit HelperDB;

interface
uses
  System.Data, System.Text, Borland.Data.Provider, Borland.Data.Common;

type
  THelperDB = class
  private
    { Private Declarations }
  public
    constructor Create;

    class function FillDataset(const SQL : string) : DataSet;
    class function FillReader(const SQL : string) : BDPDataReader;

    class function DeleteRecord(const SQL : string) : string;
    class function UpdateRecord(const SQL : string) : string;
    class function InsertRecord(const SQL : string) : string;

    class function CategoriesCount: integer;
    class function ProductsCount: integer;
    class function CustomerCount: integer;
    class function OrdersCount: integer;

    function AddProduct(const ModelName, ModelNumber, UnitCost, ProductImage, Description : string; const CategoryID : integer) : boolean;
    function UpdateProduct(const ProductID: integer; const ModelName, ModelNumber, UnitCost, ProductImage, Description : string; const CategoryID : integer) : boolean;
  end;

implementation

uses Helper;

function THelperDB.AddProduct(const ModelName, ModelNumber, UnitCost,
  ProductImage, Description: string; const CategoryID: integer): boolean;
var
  conn : BDPConnection;
  cmd : BDPCommand;
  insSQL : StringBuilder;
  parCategoryID, parModelNumber, parModelName, parProductImage, parUnitCost, parDescription  : BDPParameter;
begin
  Result := True;

    insSQL := StringBuilder.Create;
    insSQL.Append('INSERT INTO Products ');
    insSQL.Append('(CategoryID, ModelNumber, ModelName, ProductImage, UnitCost, Description) ');
    insSQL.Append(' VALUES ');
    insSQL.Append('(?, ?, ?, ?, ?, ?) ');

  	conn := BDPConnection.Create(THelper.ConnectionString);
    conn.ConnectionOptions := THelper.ConnectionOptions;
    cmd := BDPCommand.Create(insSQL.ToString, conn);

    parCategoryID := BDPParameter.Create('CategoryID',BDPType.Int32,4);
    parCategoryID.Direction := ParameterDirection.Input;
    parCategoryID.Value := System.Object(CategoryID);
    cmd.Parameters.Add(parCategoryID);

    parModelNumber := BDPParameter.Create('ModelNumber',BDPType.String,50);
    parModelNumber.Direction := ParameterDirection.Input;
    parModelNumber.Value := ModelNumber;
    cmd.Parameters.Add(parModelNumber);

    parModelName := BDPParameter.Create('ModelName',BDPType.String,50);
    parModelName.Direction := ParameterDirection.Input;
    parModelName.Value := ModelName;
    cmd.Parameters.Add(parModelName);

    parProductImage := BDPParameter.Create('ProductImage',BDPType.String,50);
    parProductImage.Direction := ParameterDirection.Input;
    if ProductImage <> '' then
      parProductImage.Value := ProductImage
    else
      parProductImage.Value := System.DBNull.Value;

    cmd.Parameters.Add(parProductImage);

    parUnitCost := BDPParameter.Create('UnitCost',BDPType.Float,15);
    parUnitCost.Direction := ParameterDirection.Input;
    parUnitCost.Value := UnitCost;
    cmd.Parameters.Add(parUnitCost);

    parDescription := BDPParameter.Create('Description',BDPType.String, 3800);
    parDescription.Direction := ParameterDirection.Input;
    parDescription.Value := Description;
    cmd.Parameters.Add(parDescription);

  try
    conn.Open;
    if cmd.ExecuteNonQuery < 1 then Result := False;
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end;

class function THelperDB.CategoriesCount: integer;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
    conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create('SELECT COUNT(CategoryID) FROM Categories', conn);

  try
    try
      conn.Open;
      Result := Convert.ToInt32(cmd.ExecuteScalar);

    except on E:BdpException do
      Result := -1
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end;

constructor THelperDB.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
end;

class function THelperDB.CustomerCount: integer;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create('SELECT COUNT(CustomerID) FROM Customers WHERE IsAdmin = 0 OR IsAdmin IS NULL', conn);
  try
    try
      conn.Open;
      Result := Convert.ToInt32(cmd.ExecuteScalar);
    except on E:BdpException do
      Result := -1
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end;

class function THelperDB.DeleteRecord(const SQL: string): string;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
  Result := 'Delete operation successful.';
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create(SQL, conn);
  try
    try
      conn.Open;
      if cmd.ExecuteNonQuery < 1 then Result := 'Cannot delete, record not found!';
    except on E:BdpException do
      Result := E.Message
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end; (*DeleteRecord*)

class function THelperDB.FillDataset(const SQL: string): DataSet;
var
  ds : DataSet;
  conn : BDPConnection;
  da : BDPDataAdapter;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  da := BDPDataAdapter.Create(SQL, conn);

	ds := DataSet.Create;
	da.Fill(ds);

	Result := ds;
end; (*FillDataset*)

class function THelperDB.FillReader(const SQL: string): BDPDataReader;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create(SQL, conn);
  conn.Open;
  Result := cmd.ExecuteReader(CommandBehavior.CloseConnection);
end; (*FillReader*)

class function THelperDB.InsertRecord(const SQL: string): string;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
  Result := 'Insert operation successful.';
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create(SQL, conn);
  try
    try
      conn.Open;
      if cmd.ExecuteNonQuery < 1 then Result := 'Cannot insert, an error occured!';
    except on E:BdpException do
      Result := E.Message
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end; (*InsertRecord*)

class function THelperDB.OrdersCount: integer;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create('SELECT COUNT(OrderID) FROM Orders', conn);
  try
    try
      conn.Open;
      Result := Convert.ToInt32(cmd.ExecuteScalar);
    except on E:BdpException do
      Result := -1
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end;

class function THelperDB.ProductsCount: integer;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create('SELECT COUNT(ProductID) FROM Products', conn);
  try
    try
      conn.Open;
      Result := Convert.ToInt32(cmd.ExecuteScalar);
    except on E:BdpException do
      Result := -1
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end;

function THelperDB.UpdateProduct(const ProductID: integer;
  const ModelName, ModelNumber, UnitCost, ProductImage, Description: string;
  const CategoryID: integer): boolean;
var
  conn : BDPConnection;
  cmd : BDPCommand;
  updSQL : StringBuilder;
  parCategoryID, parModelNumber, parModelName, parProductImage, parUnitCost, parDescription  : BDPParameter;
begin
  Result := True;

    updSQL:= StringBuilder.Create;
    updSQL.Append('UPDATE Products SET ');
    updSQL.Append('Products.ModelNumber = ?, ');
    updSQL.Append('ModelName = ?, ');
    updSQL.Append('ProductImage = ?, ');
    updSQL.Append('UnitCost = ?, ');
    updSQL.Append('Description = ?, ');
    updSQL.Append('CategoryID = ? ');
    updSQL.Append('WHERE ');
    updSQL.Append('ProductID = ' + ProductID.ToString);

  	conn := BDPConnection.Create(THelper.ConnectionString);
    conn.ConnectionOptions := THelper.ConnectionOptions;
    cmd := BDPCommand.Create(updSQL.ToString, conn);
    cmd.CommandType := CommandType.Text;

    parModelNumber := BDPParameter.Create('ModelNumber',BDPType.String,50);
    parModelNumber.Direction := ParameterDirection.Input;
    parModelNumber.Value := ModelNumber;
    cmd.Parameters.Add(parModelNumber);

    parModelName := BDPParameter.Create('ModelName',BDPType.String,50);
    parModelName.Direction := ParameterDirection.Input;
    parModelName.Value := ModelName;
    cmd.Parameters.Add(parModelName);

    parProductImage := BDPParameter.Create('ProductImage',BDPType.String,50);
    parProductImage.Direction := ParameterDirection.Input;
    parProductImage.Value := ProductImage;
    cmd.Parameters.Add(parProductImage);

    parUnitCost := BDPParameter.Create('UnitCost',BDPType.Decimal);
    parUnitCost.Direction := ParameterDirection.Input;
    parUnitCost.Value := UnitCost;
    cmd.Parameters.Add(parUnitCost);

    parDescription := BDPParameter.Create('Description',BDPType.String, 3800);
    parDescription.Direction := ParameterDirection.Input;
    parDescription.Value := Description;
    cmd.Parameters.Add(parDescription);

    parCategoryID := BDPParameter.Create('CategoryID',BDPType.Int32,4);
    parCategoryID.Direction := ParameterDirection.Input;
    parCategoryID.Value := TObject(CategoryID);
    cmd.Parameters.Add(parCategoryID);


  try
    conn.Open;
    if cmd.ExecuteNonQuery < 1 then Result := False;
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end

end;

class function THelperDB.UpdateRecord(const SQL: string): string;
var
  conn : BDPConnection;
  cmd : BDPCommand;
begin
  Result := 'Update operation successful.';
	conn := BDPConnection.Create(THelper.ConnectionString);
  conn.ConnectionOptions := THelper.ConnectionOptions;
  cmd := BDPCommand.Create(SQL, conn);
  try
    try
      conn.Open;
      if cmd.ExecuteNonQuery < 1 then Result := 'Cannot update, record not found!';
    except on E:BdpException do
      Result := E.Message
    end
  finally
    if (cmd.Connection.State = ConnectionState.Open) then	cmd.Connection.Close;
  end
end; (*UpdateRecord*)

end.
